<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cash extends Model 
{

    protected $table = 'cashs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'currency_id', 'anount', 'status');
    protected $visible = array('slug', 'currency_id', 'anount', 'status');

    public function currency()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_id');
    }

    public function CashBands()
    {
        return $this->hasMany('App\Models\CashBand', 'cash_id');
    }

}